/* 
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2001
 *  
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __CPCEMU_HEADER_INCLUDED__
#define __CPCEMU_HEADER_INCLUDED__

#include <windows.h>
#include "../../cpc/multface.h"
#include "../../cpc/cpc.h"


typedef struct 
{

	//Application config
	int	WindowWidth;
	int WindowHeight;
	RECT WindowRectBeforeMinimize;
	BOOL Minimized;
	HWND hwndStatus;
	HWND hwndToolbar;
	BOOL WindowedMode;
	int ScreenResX;
	int ScreenResY;
	HINSTANCE AppInstance;
	HINSTANCE ResourceInstance;
	int xPos, yPos,Buttons;
	BOOL DoNotScanKeyboard;

	//Application setting
	BOOL Windowed;
	BOOL FakeFS;
	int FullScreenWidth;
	int FullScreenHeight;
	int FullScreenDepth;
	HWND ApplicationHwnd;
	BOOL ApplicationIsActive;
	BOOL ApplicationHasFocus;
	HMENU hAppMenu;
	int MousePosX, MousePosY, MouseDeltaX, MouseDeltaY;
	BOOL LeftPressed, RightPressed;

	int		nFrameSkip;
} APP_DATA;
/*
typedef enum
{
	JOYSTICK_HARDWARE_AMX_MOUSE = 0,
	JOYSTICK_HARDWARE_JOYSTICK,
	JOYSTICK_HARDWARE_WESTPHASER,
	JOYSTICK_HARDWARE_SPANISH_LIGHTGUN
} JOYSTICK_HARDWARE_ID;
*/

/* define CPC types */
typedef enum
{
	CPC_TYPE_CPC464_EN = 0,
	CPC_TYPE_CPC464_FR,
	CPC_TYPE_CPC464_DK,
	CPC_TYPE_CPC664,
	CPC_TYPE_CPC6128_EN,
	CPC_TYPE_CPC6128_FR,
	CPC_TYPE_CPC6128_ES,
	CPC_TYPE_464PLUS,
	CPC_TYPE_6128PLUS,
	CPC_TYPE_KCCOMPACT,
	CPC_TYPE_ALESTE,
	CPC_TYPE_GX4000,
	CPC_TYPE_CPC464,
	CPC_TYPE_CPC6128_EN_PARADOS
} CPC_TYPE_ID;


void	DoKeyboard(void);
int		CPCEMU_Initialise(void);
void	CPCEMU_Run(void);
void	CPCEMU_Finish(void);
void	CPCEMU_SetWindowed(BOOL FakeFS=FALSE);
void	CPCEMU_SetFullScreen(void);

void CPCEMU_SetKey_VK(int win_virtualkey, BOOL bKeyDown, BOOL bNumPad);

BOOL WinApp_ProcessSystemEvents();
void MyApp_SetWindowed(int Width, int Height);
void MyApp_SetFullScreen(int Width, int Height);
void MyApp_CentraliseWindow(HWND hWindow, HWND hParent);
//int ArnoldMain(HINSTANCE hInstance, int iCmdShow, int argc, TCHAR* argv[]);


BOOL Interface_OpenCheatDatabase(void);
void Interface_InsertRom(HWND hwndParent, int RomIndex);
BOOL Interface_InsertDiskFromFile(int nDriveID, const TCHAR *sFilename);

void MyApp_GetWindowRect(RECT *pRect);

void SetCheckButtonState(HWND hDialog, int Ident, BOOL State);
//void Interface_InsertMultifaceROM(HWND hwndParent,MULTIFACE_ROM_TYPE RomType);

#ifdef _UNICODE
LPCSTR ConvertUnicodeStringToMultiByte(const TCHAR *sUnicodeString);
const TCHAR *ConvertMultiByteToUnicode(LPCSTR sMultiByte);
#endif

void CPC_SetCPCType(int type);
int CPC_GetCPCType(void);

#include "../../cpc_modified/cpc2.h"
void CPC_SetHardwareConnectedToJoystickPort(JOYSTICK_HARDWARE_ID HardwareID);
JOYSTICK_HARDWARE_ID CPC_GetHardwareConnectedToJoystickPort(void);

extern int timer_id;


#endif